/*=============================================================================}
{ Demo: how to load RVF file saved in demo editor.                             }
{ Sergey Tkachenko                                                             }
{------------------------------------------------------------------------------}
{ Providing pictures and controls on request from RichView is not supported in }
{ this demo.                                                                   }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma link "RVTable"
#pragma link "RVTInplace"
#pragma resource "*.dfm"

/*
Notes about loading from RVF files:
1. In simplest cases you can just write: RichView1->LoadRVF(<file name>);
2. If file contains inserted Delphi Controls, these controls must be registered
   with RegisterClasses functions before loading (see FormCreate below)
3. If file contains images from image lists, you need to process
   OnRVFImageListNeeded event (see RichView1RVFImageListNeeded below)
   If you have several image lists, you can distinguish them using
   ImageListTag parameter of this event.
4. You must have the same (or compatible) TRVStyle object assigned to
   RichView1->Style as in editor.
   Otherwise you can use RVStyle->LoadINI and SaveINI methods for loading
   and saving styles (new version of components allows to store styles
   just in RVF files - not supported in C++Builder 1).
5. If some items in RVF file have character strings associated as items' tags
   (rvoTagsArePChars was in editor's Options), you need also set rvoTagsArePChars
   in RichView1->Options.
*/

TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  TComponentClass Classes[3] = { __classid(TButton), __classid(TEdit), __classid(TOleContainer) };
  RegisterClasses(Classes,2);
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Button1Click(TObject *Sender)
{
  if (OpenDialog1->Execute())
  {
    if (!RichView1->LoadRVF(OpenDialog1->FileName))
      Application->MessageBox("Error Loading File", NULL, MB_OK);
    RichView1->Format();
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1RVFImageListNeeded(TCustomRichView *Sender,
    int ImageListTag, TImageList *&il)
{
  il = ImageList1;    
}
//---------------------------------------------------------------------------
